<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xd="http://www.pnp-software.com/XSLTdoc"
  xmlns:edate="http://exslt.org/dates-and-times"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tei="http://www.tei-c.org/ns/1.0"
  exclude-result-prefixes="tei edate xd" version="2.0">
  
  <xd:doc type="stylesheet">
    <xd:short>
      Feuille de style de préparation de fichiers TEI à l'importation
      TXM dans un format xml simple. 
    </xd:short>
    <xd:detail>
      This stylesheet is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License as published by the Free Software Foundation; either
      version 3 of the License, or (at your option) any later version.
      
      This stylesheet is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
      
      You should have received a copy of GNU Lesser Public License with
      this stylesheet. If not, see http://www.gnu.org/licenses/lgpl.html
    </xd:detail>
    <xd:author>Alexei Lavrentiev alexei.lavrentev@ens-lyon.fr</xd:author>
    <xd:copyright>2012, CNRS / ICAR (ICAR3 LinCoBaTO)</xd:copyright>
  </xd:doc>
  

  <xsl:output method="xml" encoding="utf-8" omit-xml-declaration="no"/>
  
	<!-- Listes des balises par type de traitement. -->
	
	<!--Par défaut, les balises sont conservées (les espaces de nommage sont
	respectés). On peut utiliser les paramètres ci-dessous pour indiquer les balises
	à supprimer en conservant ou non leur contenu--> 
	
	<!-- balises à supprimer avec leur contenu -->
	
	<xsl:param name="deleteAll">teiHeader|facsimile</xsl:param>
	
	<xsl:template match="*[matches(name(),concat('^',$deleteAll,'$'))]"/>
	
	<!-- balises à supprimer en conservant le contenu-->
	
	<xsl:param name="deleteTag"></xsl:param>
	
	<xsl:template match="*[matches(name(),concat('^',$deleteTag,'$'))]">
		<xsl:apply-templates/>
	</xsl:template>
	
  
  <xsl:template match="*">
  	<xsl:copy>
  		<xsl:apply-templates select="*|@*|processing-instruction()|comment()|text()"/>	
  	</xsl:copy>
  </xsl:template>

  <xsl:template match="@*|comment()">
    <xsl:copy/>
  </xsl:template>
	
	<xsl:template match="processing-instruction()"/>
	
	<xsl:template match="text()"><xsl:value-of select="."/></xsl:template>

	
	<xsl:template match="/tei:TEI/tei:text|/tei:TEI/tei:group">
		<text xmlns="http://www.tei-c.org/ns/1.0">
	    <xsl:apply-templates select="@*"/>
	    <xsl:attribute name="author">
	      <xsl:for-each select="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:author">
	        <xsl:value-of select="."/>
	        <xsl:if test="following-sibling::tei:author"><xsl:text>; </xsl:text></xsl:if>
	      </xsl:for-each>
	    </xsl:attribute>
	    <xsl:attribute name="title"><xsl:choose>
	      <xsl:when test="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title[@type='filing']"><xsl:value-of select="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title[@type='filing']"/></xsl:when>
	      <xsl:otherwise><xsl:value-of select="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title[1]"/></xsl:otherwise>
	    </xsl:choose></xsl:attribute>
	    <xsl:attribute name="pubdate">
	      <xsl:choose>
	        <xsl:when test="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:sourceDesc/tei:biblFull/tei:publicationStmt/tei:date[1]/@when"><xsl:value-of select="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:sourceDesc/tei:biblFull/tei:publicationStmt/tei:date[1]/@when"/></xsl:when>
	        <xsl:otherwise><xsl:value-of select="/tei:TEI/tei:teiHeader/tei:fileDesc/tei:sourceDesc/tei:biblFull/tei:publicationStmt/tei:date[1]"/></xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:attribute name="genre"><xsl:value-of select="/tei:TEI/tei:teiHeader/tei:profileDesc/tei:textClass/tei:keywords[@scheme='#mla']//tei:term[1]"/></xsl:attribute>
	    <xsl:attribute name="lang"><xsl:value-of select="/tei:TEI/tei:teiHeader/tei:profileDesc/tei:langUsage/tei:language[1]/@ident"/></xsl:attribute>
	    <xsl:apply-templates/>
	  </text>
	</xsl:template>
	
	<xsl:template match="tei:group/tei:text">
		<textPart xmlns="http://textometrie.org/1.0">
			<xsl:apply-templates/>
		</textPart>
	</xsl:template>
	
	<xsl:template match="tei:choice">
		<xsl:apply-templates select="tei:corr|tei:expan|tei:reg"></xsl:apply-templates>
	</xsl:template>
	
	<xsl:template match="tei:choice/tei:expan">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:attribute name="abbr"><xsl:value-of select="normalize-space(parent::tei:choice/tei:abbr)"/></xsl:attribute>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="tei:choice/tei:reg">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:attribute name="orig"><xsl:value-of select="normalize-space(parent::tei:choice/tei:orig)"/></xsl:attribute>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="tei:choice/tei:corr">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:attribute name="sic"><xsl:value-of select="normalize-space(parent::tei:choice/tei:sic)"/></xsl:attribute>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>